#ifndef LLF_ECPKI_ELGAMAL_H
#define LLF_ECPKI_ELGAMAL_H

/*
* All the includes that are needed for code using this module to
* Compile correctly should be #included here.
*/

#include "CE2_public.h"
#include "CE2_ECPKI_KG.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
* Creation date : Tues Mar 03 09:00:00 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains declaration of low level function
* for ElGamal encryption/decryption, which worked with 
* LibTomCrypt. 
*
* \version LLF_ECPKI_ELGAMAL.h#1:csrc:1
* \author Yermalayeu Ihar
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/
/************************ Public Variables ********************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  LLF_ECPKI_ELGAMAL_Encrypt
*
* Inputs:
* @param ReceiverUserPublKey_ptr [in] - A pointer to receiver public key 
*                           (key in little endian)
* @param MessageIn_ptr [in] - A pointer to message to be encrypted (message in big endian).
* @param MessageInSizeBytes [in] - A size of incoming message in bytes. The size must be
*                       MessageInSizeBytes =< ModulusSizeInBytes -  1.
*                       Note: in case CE2_ECPKI_DomainID_secp521r1 
*                       MessageInSizeBytes =< ModulusSizeInBytes -  2.
* @param EncrMessageOut_ptr [out] - A pointer to buffer for encrypted message.
* @param IsEphemerKeyInternal [in] - A parameter defining whether ephemeral 
*                         key internal or external
* @param EphemerPrivKeyIn_ptr [in] - A pointer to ephemeral private key.
* @param EphemerPrivKeySizeBytes [in] - A size (in bytes) of sender's ephemeral 
*                            private key data.
*
* Outputs:
* @returns \b CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*
* \brief \b 
* Description:
*  This function make Elgamal encryption.
*
* \b 
* Algorithm:
*  -# Create internal or import external ephemeral key
*  -# Import receiver key
*  -# Initialization of LibTomCrypt primitives 
*  -# Convert input message to little-endian form
*  -# Encrypt message 
*  -# Build output message
***************************************************************/
CE2Error_t  LLF_ECPKI_ELGAMAL_Encrypt (
  CE2_ECPKI_UserPublKey_t        *ReceiverUserPublKey_ptr, /*in*/
  DxUint8_t                      *MessageIn_ptr,           /*in*/
  DxUint32_t                      MessageInSizeBytes,      /*in*/
  DxUint8_t   				     *EncrMessageOut_ptr,      /*out*/
  DxInt8_t                        IsEphemerKeyInternal,    /*in*/
  DxUint8_t                      *EphemerPrivKeyIn_ptr,    /*in*/ 
  DxUint32_t                      EphemerPrivKeySizeBytes /*in*/);

/**
****************************************************************
* Function Name: 
*  LLF_ECPKI_ELGAMAL_Decrypt
*
* Inputs:
* @param ReceiverUserPrivKey_ptr [in] - A pointer to a receiver private key 
*                            structure (in affine coordinates).    				
* @param EncrMessageIn_ptr [in] - The user passed pointer to the encrypted 
*                      message buffer.
* @param DecrMessageOut_ptr [out] - The user passed pointer to buffer for output of  
*                       decrypted message.
* @param DecrMessageOutSize_ptr [in] - A pointer to size of uzer passed buffer 
*                          for decrypted message (in) and actual size 
*                          of decrypted message (out).
*                          Input value must be *DecrMessageOutSize_ptr <= 
*                         (EC modulus size in bytes) - 1. 
*                         Note: in case CE2_ECPKI_DomainID_secp521r1 input value must be 
*                         *DecrMessageOutSize_ptr <= (EC modulus size in bytes) - 2.
*
* Outputs:
* @returns \b CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*
* \brief \b 
* Description:
*  This function make Elgamal decryption.
*
* \b 
* Algorithm:
*  -# Initialization of LibTomCrypt primitives
*  -# Read input message
*  -# Decrypt message
*  -# Build decrypted output message
***************************************************************/
CE2Error_t  LLF_ECPKI_ELGAMAL_Decrypt (			      
  CE2_ECPKI_UserPrivKey_t      *ReceiverUserPrivKey_ptr,  /*in*/	
  DxUint8_t   		           *EncrMessageIn_ptr,        /*in*/
  DxUint8_t		               *DecrMessageOut_ptr,       /*out*/
  DxUint32_t                   *DecrMessageOutSize_ptr   /*in*/);

#ifdef __cplusplus
}
#endif

#endif
